/*
 * Decompiled with CFR 0.152.
 */
package com.sihenzhang.crockpot.integration.jei;

import com.sihenzhang.crockpot.integration.jei.ModIntegrationJei;
import com.sihenzhang.crockpot.tag.CrockPotItemTags;
import com.sihenzhang.crockpot.util.I18nUtils;
import com.sihenzhang.crockpot.util.RLUtils;
import java.util.List;
import java.util.stream.IntStream;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class ParrotLayingEggsRecipeCategory
implements IRecipeCategory<ParrotLayingEggsRecipeWrapper> {
    public static final RecipeType<ParrotLayingEggsRecipeWrapper> RECIPE_TYPE = RecipeType.create((String)"crockpot", (String)"parrot_laying_eggs", ParrotLayingEggsRecipeWrapper.class);
    private final IDrawable background;
    private final IDrawable icon;

    public ParrotLayingEggsRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(RLUtils.createRL("textures/gui/jei/parrot_feeding.png"), 0, 0, 87, 33);
        this.icon = guiHelper.createDrawable(ModIntegrationJei.ICONS, 48, 0, 16, 16);
    }

    public RecipeType<ParrotLayingEggsRecipeWrapper> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return I18nUtils.createIntegrationComponent("jei", "parrot_laying_eggs");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, final ParrotLayingEggsRecipeWrapper recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 8).addIngredients(recipe.ingredient);
        List eggs = ForgeRegistries.ITEMS.tags().getTag(CrockPotItemTags.PARROT_EGGS).stream().toList();
        int[] counts = IntStream.rangeClosed(recipe.min, recipe.max).filter(i -> i != 0).toArray();
        List<ItemStack> result = IntStream.range(0, eggs.size() * counts.length).mapToObj(i -> {
            Item egg = (Item)eggs.get(i % eggs.size());
            int count = counts[i % counts.length];
            return new ItemStack((ItemLike)egg, count);
        }).toList();
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 66, 8).addItemStacks(result)).addTooltipCallback(new IRecipeSlotTooltipCallback(){

            public void onTooltip(IRecipeSlotView recipeSlotView, List<Component> tooltip) {
                if (recipe.min != recipe.max) {
                    tooltip.add((Component)I18nUtils.createIntegrationComponent("jei", "min_output", recipe.min).m_130940_(ChatFormatting.GRAY));
                    tooltip.add((Component)I18nUtils.createIntegrationComponent("jei", "max_output", recipe.max).m_130940_(ChatFormatting.GRAY));
                }
            }

            public void onRichTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
                if (recipe.min != recipe.max) {
                    tooltip.add((FormattedText)I18nUtils.createIntegrationComponent("jei", "min_output", recipe.min).m_130940_(ChatFormatting.GRAY));
                    tooltip.add((FormattedText)I18nUtils.createIntegrationComponent("jei", "max_output", recipe.max).m_130940_(ChatFormatting.GRAY));
                }
            }
        });
    }

    public static class ParrotLayingEggsRecipeWrapper {
        Ingredient ingredient;
        int min;
        int max;

        public ParrotLayingEggsRecipeWrapper(Ingredient ingredient, int min, int max) {
            this.ingredient = ingredient;
            this.min = min;
            this.max = max;
        }
    }
}

